#include "Timer.h"

float Timer::elapsedTime = 0.0;	//How much time has elapsed
float Timer::levelTimeLimit = 0.0;	//How much time there is to be allocated for the current level
bool Timer::timerStopped = false;	//Whether the timer is paused

bool Timer::setWaitTime(float seconds, float dt)
{
	elapsedTime += dt;	//Increased the elapsed time by delta time

	if (elapsedTime >= seconds)	//If we've elapsed the amount of seconds
	{
		elapsedTime = 0;	//Reset the elapsed time
		return true;
	}

	return false;
}

void Timer::setLevelTime(float time)
{
	levelTimeLimit = time;	//Set the private levelTimeLimit to time
}

int Timer::getLevelTimeLeft(float dt)
{
	if (!timerStopped)	//If the timer isn't paused
	{
		levelTimeLimit -= dt;	//Subtract delta time from the level time
	}

	return levelTimeLimit;	//Return the amount of time left for the level
}

void Timer::setLevelTimeLeft(float time)
{	
	levelTimeLimit = time;	//Set the private levelTimeLimit to time
}
